/**
 * Main Javascript module for format_tiles for when user is *NOT* editing.
 * See course_edit for if they are editing.
 * Handles the UI changes when tiles are selected and anything else not
 * covered by the specific modules
 *
 * @module      format_tiles/course
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("format_tiles/course",["jquery","core/templates","core/ajax","format_tiles/browser_storage","core/notification","core/str","format_tiles/tile_fitter"],(function($,Templates,ajax,browserStorage,Notification,str,tileFitter){var isMobile,loadingIconHtml,courseId,enableCompletion,stringStore=[],scrollFuncLock=!1,sectionIsOpen=!1,reopenLastVisitedSection=!1,resizeLocked=!1,openTile=0,Selector_BODY="body",Selector_PAGE="#page",Selector_TILE=".tile",Selector_TILEID="#tile-",Selector_MOVEABLE_SECTION=".moveablesection",Selector_FILTER_BUTTON=".filterbutton",Selector_TILE_LOADING_ICON=".tile-loading-icon",Selector_TILE_CLICKABLE=".tile-clickable",Selector_TILES="ul.tiles",Selector_ACTIVITY=".activity",Selector_ACTIVITY_NAME=".activityname",Selector_INSTANCE_NAME=".instancename",Selector_SPACER=".spacer",Selector_SECTION_ID="#section-",Selector_SECTION_TITLE=".sectiontitle",Selector_SECTION_MAIN=".section.main",Selector_SECTION_BUTTONS=".sectionbuttons",Selector_CLOSE_SEC_BTN=".closesectionbtn",Selector_HIDE_SEC0_BTN="#buttonhidesec0",Selector_SECTION_ZERO="#section-0",Selector_MOODLE_VIDEO=".mediaplugin.mediaplugin_videojs",Selector_MANUAL_COMPLETION='[data-action="toggle-manual-completion"]',Selector_MATHJAX_EQUATION=".filter_mathjaxloader_equation",ClassNames_SELECTED="selected",ClassNames_OPEN="open",ClassNames_CLOSED="closed",ClassNames_LAUNCH_CM_MODAL="launch-tiles-cm-modal",ClassNames_STATE_VISIBLE="state-visible",ClassNames_HAS_OPEN_TILE="format-tiles-tile-open",Event_CLICK="click",Event_KEYDOWN="keydown",Event_SCROLL="scroll",CSS_DISPLAY="display",CSS_Z_INDEX="z-index",CSS_BG_COLOUR="background-color",Keyboard_ESCAPE=27,Keyboard_TAB=9,Keyboard_RETURN=13,stopVideoPlaying=function(section){var contentSection=$(Selector_SECTION_ID+section);contentSection.find("iframe").each((function(index,iframe){(iframe=$(iframe)).attr("src")&&(iframe.attr("data-src",iframe.attr("src")),iframe.attr("src",""))})),contentSection.find(Selector_MOODLE_VIDEO).length>0&&contentSection.html("")},cancelTileSelections=function(sectionToFocus){$(Selector_MOVEABLE_SECTION).each((function(index,sec){(sec=$(sec)).is(":visible")&&(stopVideoPlaying(sec.attr("data-section")),sec.slideUp().removeClass(ClassNames_STATE_VISIBLE))})),$(Selector_TILE).removeClass(ClassNames_SELECTED).css(CSS_Z_INDEX,"").css(CSS_BG_COLOUR,""),$(".section "+ClassNames_SELECTED).removeClass(ClassNames_SELECTED).css(CSS_Z_INDEX,""),void 0!==sectionToFocus&&0!==sectionToFocus&&$(Selector_TILEID+sectionToFocus).focus(),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html("")})),sectionIsOpen=!1,openTile=0,$(Selector_BODY).removeClass(ClassNames_HAS_OPEN_TILE),overlay.fadeOut(300)},overlay=$("#format_tiles_overlay"),setCourseContentHTML=function(contentArea,content,js){if(content){if(contentArea.html(content),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html("")})),contentArea.attr("id")!==Selector_SECTION_ZERO){var activities=contentArea.find(Selector_ACTIVITY).not(Selector_SPACER);contentArea.on(Event_KEYDOWN,(function(e){e.keyCode===Keyboard_ESCAPE&&(browserStorage.setLastVisitedSection(0),cancelTileSelections(0),$(Selector_TILEID+contentArea.attr("data-section")).focus())})),activities.on(Event_KEYDOWN,(function(e){if(e.keyCode===Keyboard_RETURN){var toClick=$(e.currentTarget).find("a");toClick.hasClass(ClassNames_LAUNCH_CM_MODAL)?toClick.click():void 0!==toClick.attr("href")&&(window.location=toClick.attr("href"))}})),isMobile||(activities.last().on(Event_KEYDOWN,(function(e){e.keyCode!==Keyboard_TAB||e.shiftKey||$(e.relatedTarget).closest(Selector_SECTION_MAIN).attr("id")===contentArea.attr("id")||setTimeout((function(){contentArea.find(Selector_SECTION_TITLE).focus(),contentArea.find(Selector_SECTION_BUTTONS).css("top","")}),200)})),contentArea.find(Selector_SECTION_TITLE).on(Event_KEYDOWN,(function(e){e.keyCode===Keyboard_TAB&&e.shiftKey&&$(e.relatedTarget).closest(Selector_SECTION_MAIN).attr("id")!==contentArea.attr("id")&&setTimeout((function(){activities.last().focus()}),200)})))}return isMobile||setTimeout((function(){try{var tooltipItems=contentArea.find(".badge-info");tooltipItems.length>0&&"function"==typeof tooltipItems.tooltip&&tooltipItems.tooltip()}catch(err){require(["core/log"],(function(log){log.debug(err)}))}}),500),0!==contentArea.find(Selector_MOODLE_VIDEO).length&&require(["media_videojs/loader"],(function(videoJS){videoJS.setUp()})),js&&js.length&&contentArea.append(js),setTimeout((function(){contentArea.find(Selector_ACTIVITY_NAME).each((function(i,el){(el=$(el)).height()>110&&el.closest(Selector_INSTANCE_NAME).addClass("opaque-bg")}))}),100),applyMathJax(contentArea),!0}return!1},applyMathJax=function(contentArea){if(void 0!==window.MathJax)try{var mathJaxElems=contentArea.find(Selector_MATHJAX_EQUATION);mathJaxElems.length&&mathJaxElems.each((function(i,node){window.MathJax.Hub.Queue(["Typeset",window.MathJax.Hub,node])}))}catch(err){require(["core/log"],(function(log){log.debug(err)}))}},expandSection=function(contentArea,tileId){var tile=$("#tile-"+tileId);contentArea.addClass(ClassNames_STATE_VISIBLE),overlay.fadeIn(300),tile.addClass(ClassNames_SELECTED),$(Selector_BODY).addClass(ClassNames_HAS_OPEN_TILE),contentArea.slideDown(350,(function(){var buttons;!function(){var scrollTo=tile.offset().top-$(Selector_TILES).offset().top+60;scrollTo===$(window).scrollTop&&(scrollTo+=1),contentArea.find(Selector_SECTION_TITLE).focus();var events="mousedown wheel DOMMouseScroll mousewheel keyup touchmove",page=$(Selector_PAGE);page.on(events,(function(){page.stop()})),page.animate({scrollTop:scrollTo},"slow","swing",(function(){page.off(events,(function(){page.stop()}))})),sectionIsOpen=!0,openTile=tileId,contentArea.find(Selector_ACTIVITY).first().focus();var iframes=contentArea.find("iframe");iframes.length>0&&(iframes.each((function(index,iframe){""===(iframe=$(iframe)).attr("src")&&void 0!==iframe.attr("data-src")&&iframe.attr("src",iframe.attr("data-src"))})),enableCompletion&&setTimeout((function(){$(document).trigger("format-tiles-completion-changed",{section:tileId})}),1e3))}(),buttons=contentArea.find(Selector_SECTION_BUTTONS),$(window).on(Event_SCROLL,(function(){!scrollFuncLock&&sectionIsOpen&&(scrollFuncLock=!0,buttons.fadeOut(300),setTimeout((function(){var windowTop=$(window).scrollTop(),desiredNewPositionInSection=windowTop-contentArea.offset().top+50;desiredNewPositionInSection>0&&desiredNewPositionInSection<contentArea.outerHeight()-100?(desiredNewPositionInSection=windowTop-contentArea.offset().top+50,buttons.css("top",desiredNewPositionInSection)):desiredNewPositionInSection<0&&buttons.css("top",0),(windowTop>contentArea.offset().top+contentArea.outerHeight()-50||contentArea.offset().top>windowTop+$(window).outerHeight())&&buttons.css("top",0),buttons.fadeIn(300,(function(){scrollFuncLock=!1}))}),500))}))})),openTile=tileId},reOrgSections=function(delayBefore,fitTilesToScreenWidth){var dfd=new $.Deferred,openedSection=$(".moveablesection:visible"),openedSectionNum=0;openedSection.length>0&&(openedSectionNum=openedSection.attr("data-section"),cancelTileSelections(0));var reOrgFunc=function(delayBefore){tileFitter.runReOrg(delayBefore).done((function(result){0!==openedSectionNum&&expandSection(openedSection,openedSectionNum),dfd.resolve(result)})).fail((function(result){0!==openedSectionNum&&expandSection(openedSection,openedSectionNum),dfd.reject(result)}))};return fitTilesToScreenWidth?setTimeout((function(){tileFitter.resizeTilesDivWidth(courseId).done((function(){reOrgFunc(!1)}),delayBefore)})):reOrgFunc(delayBefore),dfd.promise()},getSectionContentFromServer=function(courseId,sectionNum){return ajax.call([{methodname:"format_tiles_get_single_section_page_html",args:{courseid:courseId,sectionid:sectionNum,setjsusedsession:!0}}])[0]},populateAndExpandSection=function(courseId,thisTile,dataSection){$(Selector_TILE).removeClass(ClassNames_SELECTED),openTile=dataSection,$(Selector_MOVEABLE_SECTION).each((function(index,sec){(sec=$(sec)).is(":visible")&&(stopVideoPlaying(sec.attr("data-section")),sec.slideUp(200).removeClass(ClassNames_STATE_VISIBLE))})),ajax.call([{methodname:"format_tiles_log_tile_click",args:{courseid:courseId,sectionid:dataSection}}])[0].fail(Notification.exception);var relatedContentArea=$(Selector_SECTION_ID+dataSection);relatedContentArea.find(Selector_ACTIVITY).length>0?(expandSection(relatedContentArea,dataSection),getSectionContentFromServer(courseId,dataSection).done((function(response){setCourseContentHTML(relatedContentArea,$(response.html).html(),response.js)}))):(relatedContentArea.html(loadingIconHtml),getSectionContentFromServer(courseId,dataSection).done((function(response){setCourseContentHTML(relatedContentArea,$(response.html).html(),response.js),expandSection(relatedContentArea,dataSection)})).fail((function(failResult){!function(sectionNum,failResult,contentArea){throw failResult?(Notification.confirm(stringStore.sectionerrortitle,stringStore.sectionerrorstring,stringStore.refresh,stringStore.cancel,(function(){window.location.reload()}),null),contentArea.html("")):(setCourseContentHTML(contentArea,"<p>"+stringStore.noconnectionerror+"</p>",""),setTimeout((function(){expandSection(contentArea,sectionNum)}),500)),require(["core/log"],(function(log){log.debug(failResult)})),new Error("Not successful retrieving tile content by AJAX for section "+sectionNum)}(dataSection,failResult,relatedContentArea),cancelTileSelections(dataSection)}))),browserStorage.setLastVisitedSection(dataSection)};return{init:function(courseIdInit,useJavascriptNav,isMobileInit,sectionNum,useFilterButtons,assumeDataStoreConsent,reopenLastSectionInit,userId,fitTilesToWidth,enableCompletionInit){courseId=courseIdInit,isMobile=isMobileInit,reopenLastVisitedSection="1"===reopenLastSectionInit,useFilterButtons=1===useFilterButtons,assumeDataStoreConsent="1"===assumeDataStoreConsent,enableCompletion="1"===enableCompletionInit,browserStorage.init(courseId,!1,sectionNum,assumeDataStoreConsent,userId),$(document).ready((function(){var pageContent=$("#page-content");0===pageContent.length&&(pageContent=$("#region-main")),0!==sectionNum?openTile=sectionNum:reopenLastVisitedSection&&browserStorage.storageEnabledLocal&&(openTile=browserStorage.getLastVisitedSection()),0!==openTile?tileFitter.init(courseId,openTile,fitTilesToWidth,!1):($(Selector_TILEID+"1").focus(),tileFitter.init(courseId,null,fitTilesToWidth,!1));var windowWidth=$(window).outerWidth();useJavascriptNav&&(pageContent.on(Event_CLICK,Selector_TILE_CLICKABLE,(function(e){if(useJavascriptNav){e.preventDefault(),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html()}));var thisTile=$(e.currentTarget).closest(Selector_TILE),dataSection=parseInt(thisTile.attr("data-section"));thisTile.hasClass(ClassNames_SELECTED)?(cancelTileSelections(dataSection),browserStorage.setLastVisitedSection(0),overlay.fadeOut(300)):populateAndExpandSection(courseId,0,dataSection)}})),overlay.on(Event_CLICK,(function(e){cancelTileSelections(0),browserStorage.setLastVisitedSection(0),function(e){var clickedItem=$(e.currentTarget);if("format_tiles_overlay"===clickedItem.attr("id")){clickedItem.hide();var BottomElement=$(document.elementFromPoint(e.clientX,e.clientY));if(clickedItem.show(),BottomElement.hasClass("filterbutton")||BottomElement.hasClass("list-group-item"))BottomElement.click();else{var clickedTile=BottomElement.closest(Selector_TILE);clickedTile&&clickedTile.click()}}}(e)})),$(window).on("resize",(function(){resizeLocked||windowWidth===$(window).outerWidth()||(resizeLocked=!0,setTimeout((function(){var resizeRequired=!0,openContentSection=$(".moveablesection:visible");if(0!==openContentSection.length){var iframes=openContentSection.find("iframe");0!==iframes.length&&iframes.each((function(index,player){(player=$(player)).outerWidth()>openContentSection.outerWidth()&&(resizeRequired=!1)}))}resizeRequired&&(windowWidth=$(window).outerWidth(),reOrgSections(!0,fitTilesToWidth)),resizeLocked=!1}),600))})),pageContent.on(Event_CLICK,Selector_CLOSE_SEC_BTN,(function(e){cancelTileSelections($(e.currentTarget).attr("data-section"))})),function(){var buttonHideSecZero=$(Selector_HIDE_SEC0_BTN),sectionZero=$(Selector_SECTION_ZERO);browserStorage.storageEnabledLocal()?!0===browserStorage.getSecZeroCollapseStatus()?(sectionZero.slideUp(0),buttonHideSecZero.addClass(ClassNames_CLOSED).removeClass(ClassNames_OPEN)):(sectionZero.slideDown(300),buttonHideSecZero.addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED)):(buttonHideSecZero.addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED),sectionZero.slideDown(300))}()),$(document).on("format-tiles-completion-changed",(function(e,data){var allSectionNums=$(Selector_TILE).not(Selector_SPACER).map((function(i,t){return parseInt($(t).attr("data-section"))})).toArray();allSectionNums.push(0);var isSingleSectionPage=$("ul#single_section_tiles").length>0,requests=ajax.call([{methodname:"format_tiles_get_single_section_page_html",args:{courseid:courseId,sectionid:data.section,setjsusedsession:!isSingleSectionPage}},{methodname:"format_tiles_get_section_information",args:{courseid:courseId,sectionnums:allSectionNums}}]);requests[0].done((function(response){setCourseContentHTML($(Selector_SECTION_ID+data.section),$(response.html).html(),response.js)})).catch((function(err){require(["core/log"],(function(log){log.debug(err)}))})),requests[1].done((function(response){require(["format_tiles/completion"],(function(completion){completion.updateSectionsInfo(response.sections,response.overall.complete,response.overall.outof)}))})).catch((function(err){require(["core/log"],(function(log){log.debug(err)}))}))})),enableCompletion&&pageContent.on(Event_CLICK,Selector_MANUAL_COMPLETION,(function(e){var currentTarget=$(e.currentTarget),sectionNum=currentTarget.closest(Selector_SECTION_MAIN).attr("data-section"),cmid=currentTarget.attr("data-cmid");require(["format_tiles/completion"],(function(completion){setTimeout((function(){completion.triggerCompletionChangedEvent(sectionNum?parseInt(sectionNum):0,cmid?parseInt(cmid):0)}),500)}))}));var sectionZero=$(Selector_SECTION_ZERO);pageContent.on(Event_CLICK,Selector_HIDE_SEC0_BTN,(function(e){"none"===sectionZero.css(CSS_DISPLAY)?(sectionZero.slideDown(250),$(e.currentTarget).addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED),browserStorage.setSecZeroCollapseStatus("collapsed")):(sectionZero.slideUp(250),$(e.currentTarget).addClass(ClassNames_CLOSED).removeClass(ClassNames_OPEN),browserStorage.setSecZeroCollapseStatus("expanded"))})),useFilterButtons&&(require(["format_tiles/filter_buttons"],(function(filterButtons){filterButtons.init(courseId,browserStorage.storageEnabledLocal)})),useJavascriptNav&&pageContent.on(Event_CLICK,Selector_FILTER_BUTTON,(function(){cancelTileSelections(0),reOrgSections(!0,!1)}))),$(".tiles_coursenav").removeClass("hidden"),Templates.render("format_tiles/loading",{}).done((function(html){loadingIconHtml=html}));var stringKeys=[{key:"sectionerrortitle",component:"format_tiles"},{key:"sectionerrorstring",component:"format_tiles"},{key:"refresh"},{key:"cancel",component:"moodle"},{key:"noconnectionerror",component:"format_tiles"},{key:"show"},{key:"hide"},{key:"other",component:"format_tiles"}];str.get_strings(stringKeys).done((function(s){s.forEach((function(str,index){str?stringStore[stringKeys[index].key]=str:(stringStore[stringKeys[index].key]="Error.",require(["core/log"],(function(log){log.debug("Format tiles get_strings error ".concat(index)),log.debug(s)})))}))})).fail((function(err){require(["core/log"],(function(log){log.debug(err)}))})),isMobile?pageContent.on(Event_CLICK,Selector_ACTIVITY+".video a",(function(e){var target=$(e.currentTarget),url=target.closest(Selector_ACTIVITY).attr("data-url-secondary");if(void 0!==url){e.preventDefault(),e.stopPropagation();var cm=target.closest(Selector_ACTIVITY);ajax.call([{methodname:"format_tiles_log_mod_view",args:{courseid:courseId,cmid:cm.attr("data-cmid")}}])[0].done((function(){window.location=url}))}})):$(Selector_TILE).on(Event_KEYDOWN,(function(e){e.keyCode===Keyboard_RETURN&&$(e.currentTarget).click()}))}))}}}));

//# sourceMappingURL=course.min.js.map