/**
 * Javascript Module to handle browser storage for editing interface.
 *
 * @module format_tiles/edit_browser_storage
 * @copyright 2019 David Watson {@link http://evolutioncode.uk}
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since Moodle 3.3
 */
define("format_tiles/edit_browser_storage",["jquery","format_tiles/browser_storage_set_up"],(function($,storageSetUp){var courseId,userId,lastInteractedSection,Selector_PAGE="#page",Selector_SECTION_CONTENT="li.section.main .content",Selector_SECTION_MAIN="li.section.main",StorageKeys_COURSE_VISIT="mdl-tiles-editing-last-visit-course-",StorageKeys_EDITING_COURSE="mdl-tiles-editing-course-",StorageKeys_SECTION="-section-",StorageKeys_COURSE="mdl-tiles-course-",StorageKeys_LAST_SECTION="-lastSecId",StorageKeys_USER="-user-",StorageKeys_PREFIX="mdl-tiles-",StorageKeys_USER_CHOICE_PREFIX="mdl-tiles-userPrefStorage-",StorageKeys_CONTENT_SUFFIX="-content",StorageKeys_LAST_UPDATED_SUFFIX="-lastUpdated",StorageValues_OPEN="1",encodeSectionStatus=function(sectionNum){return StorageKeys_EDITING_COURSE+courseId+StorageKeys_SECTION+sectionNum+StorageKeys_USER+userId},lastSectionStorageKey=function(){return StorageKeys_COURSE+courseId+StorageKeys_USER+userId+StorageKeys_LAST_SECTION},_setLastSection=function(sectionNum){sectionNum?sectionNum!==lastInteractedSection&&storageSetUp.storageAllowed&&(lastInteractedSection=sectionNum,localStorage.setItem(lastSectionStorageKey(),sectionNum.toString())):localStorage.clear()},_setSectionStatus=function(secNum,open){storageSetUp.storageAllowed&&open?sessionStorage.setItem(encodeSectionStatus(secNum),StorageValues_OPEN):sessionStorage.removeItem(encodeSectionStatus(secNum))},clearStorage=function(){Object.keys(localStorage).filter((function(key){return 0===key.indexOf(StorageKeys_PREFIX)&&-1===key.indexOf(StorageKeys_USER_CHOICE_PREFIX)})).forEach((function(item){localStorage.removeItem(item)})),Object.keys(sessionStorage).filter((function(key){return 0===key.indexOf(StorageKeys_PREFIX)&&-1===key.indexOf(StorageKeys_USER_CHOICE_PREFIX)})).forEach((function(item){sessionStorage.removeItem(item)}))};return{getOpenSections:function(maxSection){return function(maxSection){(!maxSection||maxSection>50)&&(maxSection=50);for(var sections=[],secNum=1;secNum<=maxSection;secNum++)sessionStorage.getItem(encodeSectionStatus(secNum))===StorageValues_OPEN&&sections.push(secNum);return sections}(maxSection)},init:function(userIdInit,courseIdInit,assumeDataStoreConsent,lastSectionNum,collapsingAllFromURL){courseId=courseIdInit,userId=userIdInit,lastSectionNum&&_setSectionStatus(lastSectionNum,!0),$(document).ready((function(){if(storageSetUp.init(userId,assumeDataStoreConsent,clearStorage),Object.keys(sessionStorage).filter((function(key){return 0===key.indexOf(StorageKeys_PREFIX)&&(key.indexOf(StorageKeys_CONTENT_SUFFIX)===key.length-StorageKeys_CONTENT_SUFFIX.length||key.indexOf(StorageKeys_LAST_UPDATED_SUFFIX)===key.length-StorageKeys_LAST_UPDATED_SUFFIX.length)})).forEach((function(item){sessionStorage.removeItem(item)})),storageSetUp.storageAllowed()){if(sessionStorage.setItem(StorageKeys_COURSE_VISIT+courseId+StorageKeys_USER+userId,Date.now().toString()),collapsingAllFromURL)for(var i=1;i<=lastSectionNum;i++)_setSectionStatus(i,!1);$(Selector_PAGE).on("click",Selector_SECTION_CONTENT,(function(e){var sectionClicked=$(e.currentTarget).closest(Selector_SECTION_MAIN).attr("data-section");_setLastSection(sectionClicked)}))}}))},getLastSection:function(){return lastInteractedSection||(lastInteractedSection=localStorage.getItem(lastSectionStorageKey())),lastInteractedSection},setSectionStatus:function(secNum,open){return _setSectionStatus(secNum,open)},setLastSection:function(secNum){return _setLastSection(secNum)}}}));

//# sourceMappingURL=edit_browser_storage.min.js.map