/**
 * Javascript Module to handle edit actions on course modules.
 *
 * @module      format_tiles/edit_course_mod
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */
define("format_tiles/edit_course_mod",["jquery","core/ajax","core/templates","core/notification","core/str","core/url","core/config"],(function($,ajax,Templates,Notification,str,url,config){var stringStore={},body=$("html,body"),page=$("#page"),Selector_MENU_ACTION=".menu-action-text",Selector_SUBTILE=".subtile",Selector_SPACER=".spacer",Selector_AVAIL_INFO=".availabilityinfo",Selector_ACTIVITY_INSTANCE=".subtile-activityinstance",Selector_INSTANCE_NAME=".instancename",Selector_SECTION_CM_EDIT_ACTIONS=".section-cm-edit-actions",Selector_EDITING_MOVE=".editing_move",Selector_CM_EDIT_ACTION=".cm-edit-action",Selector_ACTIVITY_ICON=".activityicon",Selector_EDITING_DELETE=".editing_delete",Selector_SECTION_MAIN=".section.main",Selector_STEALTH_UNAVAIL_LINK=".editing_makeunavailable",ClassNames_SHOW="show",ClassNames_HIDE="hide",ClassNames_FA_EYE_SLASH="fa-eye-slash",ClassNames_FA_EYE="fa-eye",ClassNames_DIMMED="dimmed",ClassNames_EDITING="editing_",ClassNames_ACTIVITY="activity",ClassNames_LABEL="label",ClassNames_SECTION_DRAGGABLE="sectiondraggable",Event_CLICK="click",Event_MODULE_ADDED="filter-content-updated",Event_MOUSEDOWN="mousedown",legacyCourseModGetSubtileAttributes=function(cmObject,modResourceType,displayname){void 0!==displayname&&""!==displayname||(displayname=stringStore.other),cmObject.find("a.cm-edit-action").each((function(index,editItem){$(editItem).attr("data-action","")})),cmObject.find("a.editing_moveright").remove();var returnData={cmid:cmObject.attr("id").split("-").slice(-1)[0],activityname:cmObject.find(Selector_INSTANCE_NAME).html().split("<")[0],cmeditmenu:cmObject.find(Selector_SECTION_CM_EDIT_ACTIONS)[0].outerHTML.replace(/\n/g,""),cmmove:cmObject.find(Selector_EDITING_MOVE)[0].outerHTML,modname:"resource",modResourceType:modResourceType,modnameDisplay:displayname,useSubtiles:1,isEmbeddedResource:0,clickable:1,isediting:1,visible:1};return returnData.isPdf="pdf"===returnData.modResourceType,returnData};return{init:function(courseId){$(document).ready((function(){Y.use("moodle-course-coursebase",(function(){void 0!==M.course&&setTimeout((function(){M.course.coursebase.registermodules=[]}),500)})),page.on("click",Selector_CM_EDIT_ACTION,(function(e){!function(clickEvent){var actions,clickedLink=$(clickEvent.currentTarget);if("tiles-hide"===clickedLink.attr("data-action")?(actions={changeTo:ClassNames_HIDE,old:ClassNames_SHOW},$(Selector_STEALTH_UNAVAIL_LINK).hide()):"tiles-show"===clickedLink.attr("data-action")&&(actions={changeTo:ClassNames_SHOW,old:ClassNames_HIDE}),actions){clickEvent.preventDefault(),clickedLink.attr("data-action","tiles-"+actions.old);var promises=ajax.call([{methodname:"core_course_edit_module",args:{id:clickedLink.attr("data-cmid"),action:actions.changeTo}}],!0);promises[0].done((function(HTMLresult){clickedLink.removeClass(ClassNames_EDITING+actions.old).addClass(ClassNames_EDITING+actions.changeTo),clickedLink.attr("href",clickedLink.attr("href").replace("&"+actions.old+"=","&"+actions.changeTo+"="));var menuActionText=clickedLink.find(Selector_MENU_ACTION),subtile=clickedLink.closest(Selector_SUBTILE);actions.changeTo===ClassNames_SHOW?(menuActionText.html(menuActionText.html().replace(stringStore.show,stringStore.hide)),clickedLink.find("i").removeClass(ClassNames_FA_EYE_SLASH).addClass(ClassNames_FA_EYE),subtile.removeClass(ClassNames_DIMMED)):actions.changeTo===ClassNames_HIDE&&(menuActionText.html(menuActionText.html().replace(stringStore.hide,stringStore.show)),clickedLink.find("i").removeClass(ClassNames_FA_EYE).addClass(ClassNames_FA_EYE_SLASH),subtile.addClass(ClassNames_DIMMED));var newAvailabilityInfo=$(HTMLresult).find(Selector_AVAIL_INFO),oldAvailabilityInfo=subtile.find(Selector_AVAIL_INFO);newAvailabilityInfo?oldAvailabilityInfo.length?oldAvailabilityInfo.replaceWith(newAvailabilityInfo):newAvailabilityInfo.appendTo(subtile.find(Selector_ACTIVITY_INSTANCE)):oldAvailabilityInfo.hide()})),promises[0].fail((function(){window.location.replace(clickedLink.attr("href"))}))}}(e)})),$(document).on(Event_MODULE_ADDED,(function(event,msg){var addedCourseModule=$("#"+$(msg).attr("id")),sectionAddedTo=addedCourseModule.closest(Selector_SECTION_MAIN);sectionAddedTo.length>=1&&function(courseId,addedCourseModule,sectionAddedTo,msg){if(sectionAddedTo.hasClass(ClassNames_SECTION_DRAGGABLE)&&-1===window.location.href.indexOf("expand="))window.location=config.wwwroot+"/course/view.php?id="+courseId+"&expand="+sectionAddedTo.attr("data-section")+"#section-"+sectionAddedTo.attr("data-section");else if(addedCourseModule.hasClass(ClassNames_LABEL)&&addedCourseModule.closest("ul").hasClass("subtiles"))window.location.reload();else if(addedCourseModule.hasClass(ClassNames_ACTIVITY)&&addedCourseModule.closest("ul").hasClass("subtiles")){addedCourseModule.children().hide(),addedCourseModule.append($("<img/>").attr("src",url.imageUrl("loading","format_tiles")).addClass("loading-subtile").attr("title",stringStore.loading));var previousNonSpacer=addedCourseModule.prevAll(Selector_SUBTILE).not(Selector_SPACER).first();addedCourseModule.prevUntil(previousNonSpacer,Selector_SPACER).hide();var modResourceType={powerpoint:"ppt",document:"doc",spreadsheet:"xls",archive:"zip",pdf:"pdf",mp3:"mp3",mpeg:"mp4",jpeg:"jpeg",text:"txt",html:"html"}[addedCourseModule.find(Selector_ACTIVITY_ICON).attr("src").split("/").slice(-1)[0].split("-")[0]];void 0===modResourceType&&window.location.reload();var stringKey="displaytitle_mod_"+modResourceType;if(void 0===stringStore[stringKey])str.get_string(stringKey,"format_tiles").done((function(string){"[["!==string.substring(0,2)?stringStore[stringKey]=string:string="";var cmAttributes=legacyCourseModGetSubtileAttributes(addedCourseModule,modResourceType,string);Templates.render("format_tiles/course_module",cmAttributes).done((function(html){addedCourseModule.replaceWith(html);var newItem=$("#"+$(msg).attr("id"));body.animate({scrollTop:newItem.offset().top-130},"fast");for(var x=0;x<3;x++)newItem.fadeOut(300).fadeIn(300);$("#module-"+cmAttributes.cmid).find(".editing_move").attr("data-action","").on(Event_MOUSEDOWN,(function(){window.location.reload()}))}))}));else{var cmAttributes=legacyCourseModGetSubtileAttributes(addedCourseModule,modResourceType,stringStore[stringKey]);Templates.render("format_tiles/course_module",cmAttributes).done((function(html){addedCourseModule.replaceWith(html),$("#module-"+cmAttributes.cmid).find(".editing_move").attr("data-action","").on(Event_MOUSEDOWN,(function(){window.location.reload()}))}))}}else addedCourseModule.find("div.mod-indent-outer").css("position","absolute").css("top","0").css("width","100%").css("padding-left","0")}(courseId,addedCourseModule,sectionAddedTo,msg)})),page.on(Event_CLICK,Selector_EDITING_DELETE,(function(e){var deletedItem=$(e.currentTarget).closest("li"+ClassNames_ACTIVITY),previousNonSpacer=deletedItem.prevAll(Selector_SUBTILE).not(Selector_SPACER).first();deletedItem.hasClass(ClassNames_LABEL)&&deletedItem.prevUntil(previousNonSpacer,Selector_SPACER).hide()})),str.get_strings([{key:"yes"},{key:"no"},{key:"show"},{key:"hide"},{key:"areyousure"},{key:"complete",component:"format_tiles"},{key:"fileaddedtobottom",component:"format_tiles"},{key:"loading",component:"format_tiles"}]).done((function(s){stringStore={yes:s[0],no:s[1],show:s[2],hide:s[3],areyousure:s[4],complete:s[5],fileaddedtobottom:s[6],loading:s[7]}}))}))}}}));

//# sourceMappingURL=edit_course_mod.min.js.map