function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * Javascript Module to handle the icon picker dialogue for format_tiles
 * which the editing user uses to select an icon for a tile or the default icon
 * for all tiles in the course
 *
 * @module      format_tiles/icon_picker
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */}define("format_tiles/edit_icon_picker",["jquery","core/templates","core/ajax","core/str","core/notification","core/config"],(function($,Templates,ajax,str,Notification,config){var modalStored,stringStore={pickAnIcon:""},iconSet=[],recentPhotoSet=[],getAndStoreIconSet=function(courseId,callback){var photosPromises=ajax.call([{methodname:"format_tiles_get_icon_set",args:{courseid:courseId}}]);photosPromises[0].done((function(response){response.photos&&(recentPhotoSet=JSON.parse(response.photos));var icons=JSON.parse(response.icons);Object.keys(icons).forEach((function(icon){iconSet.push({filename:icon,displayname:icons[icon]})})),iconSet.length<=0&&require(["core/log"],(function(log){log.error("Error empty icon set"),log.debug(response)})),"function"==typeof callback&&callback();var photoNames=recentPhotoSet.map((function(photo){return photo.filename}));$("#iconpickerphotos").find(".photo").each((function(index,ph){ph=$(ph),-1===photoNames.indexOf(ph.attr("data-filename"))&&ph.fadeOut(500)})),!0!==response.status&&require(["core/log"],(function(log){log.error("Non true status response when getting icon set"),log.debug(response)}))})),photosPromises[0].fail((function(response){require(["core/log"],(function(log){log.error("Fail when getting icon set"),log.debug(response)}))}))},getPhotoTileButtonUrl=function(courseId,sectionId){return config.wwwroot+"/course/format/tiles/editimage.php?courseid="+courseId+"&sectionid="+sectionId},setIcon=function(sectionId,sectionNum,icon,displayname,pageType,courseId,imageType,sourcecontextid,sourceitemid){var selectedIcon=$("#selectedicon"),changeUiTilePhoto=function(jqueryObjToChange,imageUrl,imageType){var templateToRender="",templateParams={tileicon:icon,num:sectionNum,id:sectionId,isediting:1};switch(imageType){case"tileicon":templateToRender="tileicon";break;case"tilephoto":templateToRender="tilebarphoto",templateParams.phototileurl=imageUrl,templateParams.phototileediturl=getPhotoTileButtonUrl(courseId,sectionId),templateParams.iamgetype=imageType,jqueryObjToChange.closest(".tileiconcontainer").addClass("hasphoto"),setTimeout((function(){getAndStoreIconSet(courseId)}),3e3);break;case"draftfile":templateToRender="tilebarphoto",templateParams.phototileurl=imageUrl,templateParams.phototileediturl=getPhotoTileButtonUrl(courseId,sectionId),templateParams.iamgetype=imageType;break;default:throw new Error("Invalid image type "+imageType)}var divToAnimate="course-view-tiles"===pageType?jqueryObjToChange:selectedIcon;divToAnimate.animate({opacity:0},500,(function(){Templates.render("format_tiles/"+templateToRender,templateParams).done((function(html){divToAnimate.html(html).animate({opacity:1},500)}))})),"course-editsection"===pageType&&"tilephoto"===imageType&&$("input[name=tilephoto]").val(icon)},ajaxIconPickArgs={image:icon,courseid:courseId,sectionid:sectionId,imagetype:imageType,sourcecontextid:void 0===sourcecontextid?0:sourcecontextid,sourceitemid:void 0===sourceitemid?0:sourceitemid};ajax.call([{methodname:"format_tiles_set_image",args:ajaxIconPickArgs}])[0].done((function(response){if(!0===response.status)if("course-view-tiles"===pageType)changeUiTilePhoto($("#tileicon_"+sectionNum),response.imageurl,imageType);else if("course-edit"===pageType||"course-editsection"===pageType){var selectBox=$("#id_defaulttileicon");"course-editsection"===pageType&&(selectBox=$("#id_tileicon")),selectBox.val(icon),"tileicon"===imageType?(Templates.renderPix("tileicon/"+icon,"format_tiles",displayname).done((function(newIcon){selectedIcon.html(newIcon),"course-editsection"===pageType&&str.get_strings([{key:"tip",component:"format_tiles"},{key:"tileselecttip",component:"format_tiles"}]).done((function(strings){Notification.alert(strings[0],strings[1])}))})),"course-editsection"===pageType&&$("input[name=tilephoto]").val("")):"tilephoto"===imageType&&changeUiTilePhoto($("#tileicon_"+sectionNum),response.imageurl,imageType)}})).fail((function(response){require(["core/log"],(function(log){log.error("Fail setting icon"),log.debug(response)}))}))},launchIconPicker=function(pageType,courseId,sectionId,section,allowPhotoTiles,documentationurl){if("object"!==_typeof(modalStored)){var renderModal=function(){Templates.render("format_tiles/icon_picker_modal_body",{icon_picker_icons:iconSet,photosallowed:allowPhotoTiles,wwwroot:config.wwwroot,documentationurl:documentationurl}).done((function(iconsHTML){require(["core/modal_factory"],(function(modalFact){modalFact.create({type:modalFact.types.DEFAULT,title:stringStore.pickAnIcon,body:iconsHTML}).done((function(modal){modalStored=modal,modal.setLarge(),modal.show();var modalRoot=$(modal.root);modalRoot.attr("id","icon_picker_modal"),modalRoot.attr("data-true-sectionid",sectionId),modalRoot.attr("data-section",section),modalRoot.addClass("icon_picker_modal"),modalRoot.on("click",".pickericon",(function(e){var newIcon=$(e.currentTarget);setIcon(sectionId,section,newIcon.attr("data-icon"),newIcon.attr("title"),pageType,courseId,"tileicon",newIcon.attr("data-contextid"),newIcon.attr("data-itemid")),modal.hide()})),modalRoot.on("input","input.iconsearch",(function(e){var searchText=e.currentTarget.value.toLowerCase();modalRoot.find(".pickericon").show(),searchText.length>=3&&modalRoot.find(".pickericon").filter((function(index,icon){return $(icon).attr("data-original-title").toLowerCase().indexOf(searchText)<0})).hide()}));try{var pickerIcon=$(".pickericon");"function"==typeof pickerIcon.tooltip&&pickerIcon.tooltip()}catch(err){require(["core/log"],(function(log){log.debug(err)}))}if(allowPhotoTiles){var url=getPhotoTileButtonUrl(courseId,sectionId);modalRoot.find("#phototilebtn").attr("href",url),$("#launch-photo-library").click((function(){0!==recentPhotoSet.length&&Templates.render("format_tiles/icon_picker_photos",{icon_picker_photos:recentPhotoSet,wwwroot:config.wwwroot}).done((function(photosHTML){!function(photosHTML,modalRoot,modal){var photoLibrary=$("#iconpickerphotos");photoLibrary.html(photosHTML);var doLast=[];photoLibrary.find("img").each((function(index,image){(image=$(image)).attr("data-filesize")<2e5?setTimeout((function(){image.attr("src",image.attr("data-url"))}),20*index):doLast.push(image),image.click((function(e){var clickedImage=$(e.currentTarget);setIcon(modalRoot.attr("data-true-sectionid"),modalRoot.attr("data-section"),clickedImage.attr("data-filename"),clickedImage.attr("data-filename"),pageType,courseId,clickedImage.attr("data-imagetype"),clickedImage.attr("data-contextid"),clickedImage.attr("data-itemid")),modal.hide()}))})),setTimeout((function(){doLast.forEach((function(image){image.attr("src",image.attr("data-url"))}))}),1e3)}(photosHTML,modalRoot,modal)}))}))}}))}))}))};iconSet.length<=0?getAndStoreIconSet(courseId,renderModal):renderModal()}else{if(modalStored.root.attr("data-true-sectionid",sectionId),modalStored.root.attr("data-section",section),modalStored.root.off("click"),modalStored.root.on("click",".pickericon",(function(e){var newIcon=$(e.currentTarget);setIcon(sectionId,section,newIcon.attr("data-icon"),newIcon.attr("title"),pageType,courseId,newIcon.attr("data-imagetype"),newIcon.attr("data-contextid"),newIcon.attr("data-itemid")),modalStored.hide()})),allowPhotoTiles){var url=getPhotoTileButtonUrl(courseId,sectionId);modalStored.root.find("#phototilebtn").attr("href",url)}modalStored.show()}};return{init:function(courseId,pageType,allowPhotoTiles,documentationurl){$(document).ready((function(){var stringKey=allowPhotoTiles?"picknewiconphoto":"picknewicon";str.get_string(stringKey,"format_tiles").done((function(pickAnIcon){stringStore.pickAnIcon=pickAnIcon})),getAndStoreIconSet(courseId);var pageContent=$("#page-content");0===pageContent.length&&(pageContent=$("#region-main")),pageContent.on("click",'[data-action="launch-tiles-icon-picker"]',(function(e){e.preventDefault();var clickedIcon=$(e.currentTarget);launchIconPicker(pageType,courseId,clickedIcon.attr("data-true-sectionid"),clickedIcon.attr("data-section"),allowPhotoTiles,documentationurl)}))}))}}}));

//# sourceMappingURL=edit_icon_picker.min.js.map