/**
 * Javascript Module to handle fitting tiles to screen.
 * Called when in non editing mode.
 *
 * @module format_tiles/tile_fitter
 * @copyright 2019 David Watson {@link http://evolutioncode.uk}
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since Moodle 3.3
 */
define("format_tiles/tile_fitter",["jquery","core/ajax"],(function($,ajax){var courseId,reOrgLocked=!1,Selector_TILE=".tile",Selector_TILEID="#tile-",Selector_TILE_COLLAPSED=".tile-collapsed",Selector_TILES=".format-tiles.jsenabled ul.tiles",Selector_SPACER=".spacer",Selector_SECTION_ID="#section-",Selector_OPEN_SECTION=".moveablesection:visible",Selector_SECTION_ZERO="#section-0",Selector_CONTENT_SECTIONS=".moveablesection",timeoutBeforeResizeAjax=null,_resizeTilesDivWidth=function(){var winWidth=$(window).width(),dfd=new $.Deferred,tiles=$(Selector_TILES),TILE_WIDTHS_standard=260,TILE_WIDTHS_min=225,TILE_WIDTHS_mobileMin=160;try{var tilesParentWidth=tiles.parent().innerWidth(),firstTile=$(tiles.find(Selector_TILE)[0]),oneTileWidth=firstTile.width()?firstTile.width():TILE_WIDTHS_standard;oneTileWidth+=14;var resizeWidth="inherit",maxPossibleTilesPerRow=Math.floor(tilesParentWidth/TILE_WIDTHS_min),tileCount=$(Selector_TILE).not(Selector_SPACER).length;if(tilesParentWidth<2*TILE_WIDTHS_mobileMin)dfd.reject("Too narrow to resize");else if(tileCount<=3&&tilesParentWidth>tileCount*TILE_WIDTHS_mobileMin)resizeWidth=4*TILE_WIDTHS_standard;else if(tilesParentWidth<3*TILE_WIDTHS_min)resizeWidth=2*(TILE_WIDTHS_standard-14);else if(maxPossibleTilesPerRow<4)resizeWidth=TILE_WIDTHS_standard*maxPossibleTilesPerRow;else{var rowMaxCount=Math.min(Math.floor(tilesParentWidth/oneTileWidth),tileCount);if(tileCount<=rowMaxCount&&tileCount>5)resizeWidth=(Math.floor(tileCount/2)+1)*oneTileWidth;else if(rowMaxCount>3&&tileCount/rowMaxCount<=3){var rowMinCount=Math.floor(tilesParentWidth/oneTileWidth),possibleRowCounts=function(start,end){for(var res=[];start<=end;start+=1)res.push(start);return res}(rowMinCount,rowMaxCount).reverse(),lastRowRemainderTiles=possibleRowCounts.map((function(num){return tileCount%num}));resizeWidth=-1!==lastRowRemainderTiles.indexOf(0)?oneTileWidth*possibleRowCounts[lastRowRemainderTiles.indexOf(0)]:tileCount<rowMinCount?tileCount*oneTileWidth:oneTileWidth*possibleRowCounts[lastRowRemainderTiles.indexOf(Math.max.apply(null,lastRowRemainderTiles))]}else resizeWidth=rowMaxCount*oneTileWidth}var existingWidth=parseInt(tiles.css("max-width").replace("px",""));if(Math.abs(resizeWidth-existingWidth)<100)dfd.resolve();else{tiles.css("max-width",winWidth).animate({"max-width":resizeWidth},500,"swing",(function(){setTimeout((function(){dfd.resolve()}),600),$(Selector_CONTENT_SECTIONS).animate({"max-width":resizeWidth},500,"swing")}))}timeoutBeforeResizeAjax&&clearTimeout(timeoutBeforeResizeAjax),timeoutBeforeResizeAjax=setTimeout((function(){ajax.call([{methodname:"format_tiles_set_session_width",args:{courseid:courseId,width:Math.floor(resizeWidth)}}])}),3e3)}catch(err){tiles.css("max-width",winWidth).animate({"max-width":"100%"},500,"swing"),ajax.call([{methodname:"format_tiles_set_session_width",args:{courseid:courseId,width:0}}]),dfd.reject("Failed to resize")}return dfd.promise()},organiser={getContentSectionPositions:function(){var currentSectionId,previousTile,rows=[],openSections=$(Selector_OPEN_SECTION);openSections.css("display","none");var maxTilesPerRow=1,thisRowCount=0,allTiles=$(Selector_TILES).children(Selector_TILE).not(Selector_TILE_COLLAPSED).not(".spacer");return 0===allTiles.length?[]:(allTiles.each((function(index,tile){(currentSectionId=$(tile).attr("data-section"))&&(0===index?thisRowCount=1:Math.abs($(tile).position().top-$(previousTile).position().top)<=100?thisRowCount+=1:thisRowCount=0,thisRowCount>maxTilesPerRow&&(maxTilesPerRow=thisRowCount),previousTile=tile)})),openSections.css("display","block"),allTiles.each((function(index,tile){currentSectionId=$(tile).attr("data-section"),0===rows.length||rows[rows.length-1].sections.length>=maxTilesPerRow?(rows.length>=1&&(rows[rows.length-1].displayAfterTile=rows[rows.length-1].sections[rows[rows.length-1].sections.length-1]),rows.push({displayAfterTile:"",sections:[currentSectionId]})):rows[rows.length-1].sections.push(currentSectionId)})),rows[rows.length-1].displayAfterTile=rows[rows.length-1].sections[rows[rows.length-1].sections.length-1],rows)},moveContentSectionsToPlaces:function(positionData,callbacks){positionData.forEach((function(row){row.sections.forEach((function(contentSection){row.displayAfterTile===positionData[positionData.length-1].displayAfterTile?$(Selector_SECTION_ID+contentSection).detach().insertAfter($("ul.tiles .tile").last()):$(Selector_SECTION_ID+contentSection).detach().insertAfter($("#tile-"+row.displayAfterTile))}))})),callbacks.forEach((function(func){"function"==typeof func&&func()}))},runReOrg:function(delayBefore){var dfd=new $.Deferred;!0===reOrgLocked&&dfd.reject("Re-org locked"),reOrgLocked=!0;var action=function(){organiser.moveContentSectionsToPlaces(organiser.getContentSectionPositions(),[function(){$("body").removeClass("modal-open"),dfd.resolve("Finished organising tiles"),reOrgLocked=!1}])};return!0===delayBefore?setTimeout((function(){action(),dfd.resolve("Re-org complete")}),1e3):(action(),dfd.resolve("Re-org complete")),dfd.promise()}};return{init:function(courseIdInit,sectionOpen,fitTilesToWidth,isEditing){courseId=courseIdInit,$(document).ready((function(){$(".block-hider-hide").click((function(){organiser.runReOrg(!0)})),$(".block-hider-show").click((function(){organiser.runReOrg(!0)})),$('.navbar button[data-action="toggle-drawer"]').click((function(){setTimeout((function(){organiser.runReOrg(!0),_resizeTilesDivWidth()}),600)})),"1"===$(Selector_TILES).css("opacity")&&organiser.runReOrg(!1).done((function(){0!==sectionOpen&&$(Selector_TILEID+sectionOpen).click()}));var organiseAndRevealTiles=function(){organiser.runReOrg(!1).done((function(){0!==sectionOpen&&0===$(Selector_OPEN_SECTION).length&&$(Selector_TILEID+sectionOpen).click(),$(Selector_TILES).animate({opacity:"1"},"fast"),$(Selector_SECTION_ZERO).animate({opacity:"1"},"fast"),$("#page-loading-icon").fadeOut(500).remove()}))};fitTilesToWidth&&!isEditing?_resizeTilesDivWidth().done((function(){organiseAndRevealTiles()})).fail((function(){organiseAndRevealTiles()})):organiseAndRevealTiles()}))},resizeTilesDivWidth:function(){return _resizeTilesDivWidth()},runReOrg:function(delayBefore){return organiser.runReOrg(delayBefore)}}}));

//# sourceMappingURL=tile_fitter.min.js.map