<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings definition
 *
 * @package     local_disablerightclick
 * @copyright   2020 Yogesh Shirsath <yogshirsath@hotmail.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author      Yogesh Shirsath
 */

$string['pluginname'] = 'Disable Right Click';
$string['disablerightclickdesc'] = 'Right click(Context Menu) will be disabled throughout the site(Except Admin and Manager).';
$string['disablecutcopypaste'] = 'Disable Cut, Copy and Paste';
$string['disablecutcopypastedesc'] = 'Cut, Copy and Paste will be disabled throughout the site(Except Admin and Manager).';
$string['disabledevelopertools'] = 'Disable Developer tool shortcuts';
$string['disabledevelopertoolsdesc'] = 'Developer tool shortcuts(<a target="_blank" href="https://developers.google.com/web/tools/chrome-devtools/shortcuts">Chrome shortcuts list</a>) will be disabled throughout the site(Except Admin and Manager). Note: Tools can be opened through browser settings menu. Cannot disable that.';
$string['disablerightclick:allow'] = 'Allow all for user roles';
$string['supporttitle'] = 'Support my work';
$string['supportlater'] = 'Later';
$string['supportlaterdesc'] = 'Show me after 7 days';
$string['supportnever'] = 'Never';
$string['supportneverdesc'] = 'Don\'t show this again';
$string['supportmessage'] = 'If you like <strong>' . $string['pluginname'] . '</strong> plugin then please support me on';

// Allowing message.
$string['allowall'] = 'Allow all';
$string['allowalldesc'] = 'Allow all on above pages';
$string['allowrightclick'] = 'Allow right click';
$string['allowrightclickdesc'] = 'Allow right click on above pages';
$string['allowcutcopypaste'] = 'Allow cut, copy and paste';
$string['allowcutcopypastedesc'] = 'Allow cut, copy and paste on above pages';
$string['allowdevelopertools'] = 'Allow developer tools';
$string['allowdevelopertoolsdesc'] = 'Allow developer tools on above pages';

// Warnings.
$string['rightclick'] = 'Right click is disabled on this site.';
$string['cutcopypaste'] = 'Cut, Copy and Paste is disabled on this site.';
$string['developertools'] = 'Developer tools are disabled on this site.';
$string['developertoolsopened'] = 'Please close developer tool to see page.';
