<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Theme version page.
 * @package    theme_enlightlite
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

 return array(
    'default' => array(
        'color_primary' => "#39b3e6",
        'color_secondary' => "#353535",
        'color_carousel_control' => '#005f92',
        'color_comment_link' => '#003e5f',
        'color_mdl_left_background' => '#ddeef8',
        'color_comment_list_background' => '#cde2ee',
        'color_comment_list_border' => '#b8d3e2',
        'color_picton_50_approx' => 'rgba(57, 179, 230, .5)',
        'color_dropdown_background' => '#444',
        'color_navtop_50_approx' => 'rgba(53, 53, 53, .5)',
        'color_picton_90_approx' => 'rgba(57, 179, 230, .9)',
        'color_picton_60_approx' => 'rgba(57, 179, 230, .6)',
        'color_picton_70_approx' => 'rgba(57, 179, 230, 0.70)',
        'color_picton_25_approx' => 'rgba(57, 179, 230, 0.25)',
        'color_tuatara_70_approx' => 'rgba(53, 53, 53, .7)'
    ),

    '1' => array(
        'color_primary' => "#7abb3b",
        'color_secondary' => "#353535",
        'color_carousel_control' => '#54a307',
        'color_comment_link' => '#37640b',
        'color_mdl_left_background' => '#dcfdbc',
        'color_comment_list_background' => '#c1ec98',
        'color_comment_list_border' => '#95d15b',
        'color_picton_50_approx' => 'rgba(122, 187, 59, .5)',
        'color_dropdown_background' => '#424242',
        'color_navtop_50_approx' => 'rgba(53, 53, 53, .5)',
        'color_picton_90_approx' => 'rgba(122, 187, 59, .9)',
        'color_picton_60_approx' => 'rgba(122, 187, 59, .6)',
        'color_picton_70_approx' => 'rgba(122, 187, 59, .75)',
        'color_picton_25_approx' => 'rgba(122, 187, 59, .25)',
        'color_tuatara_70_approx' => 'rgba(53, 53, 53, .7)'
    ),

    '2' => array(
        'color_primary' => "#8e558e",
        'color_secondary' => "#2a2a2a",
        'color_carousel_control' => '#853d85',
        'color_comment_link' => '#541f54',
        'color_mdl_left_background' => '#ffe3ff',
        'color_comment_list_background' => '#f1c7f1',
        'color_comment_list_border' => '#b980b9',
        'color_picton_50_approx' => 'rgba(142, 85, 142, .5)',
        'color_dropdown_background' => '#3b3b3b',
        'color_navtop_50_approx' => 'rgba(42, 42, 42, .5)',
        'color_picton_90_approx' => 'rgba(142, 85, 142, .9)',
        'color_picton_60_approx' => 'rgba(142, 85, 142, .6)',
        'color_picton_70_approx' => 'rgba(142, 85, 142, .75)',
        'color_picton_25_approx' => 'rgba(142, 85, 142, .25)',
        'color_tuatara_70_approx' => 'rgba(42, 42, 42, 0.7)'
    ),

    '3' => array(
        'color_primary' => "#e14d43",
        'color_secondary' => "#2a2a2a",
        'color_carousel_control' => '#c83f35',
        'color_comment_link' => '#98271e',
        'color_mdl_left_background' => '#ffdbd9',
        'color_comment_list_background' => '#ebb8b6',
        'color_comment_list_border' => '#f98179',
        'color_picton_50_approx' => 'rgba(225, 77, 67, .5)',
        'color_dropdown_background' => '#333',
        'color_navtop_50_approx' => 'rgba(42, 42, 42, .5)',
        'color_picton_90_approx' => 'rgba(225, 77, 67, .9)',
        'color_picton_60_approx' => 'rgba(225, 77, 67, .6)',
        'color_picton_70_approx' => 'rgba(225, 77, 67, .75)',
        'color_picton_25_approx' => 'rgba(225, 77, 67, .25))',
        'color_tuatara_70_approx' => 'rgba(42, 42, 42, 0.7)'
    ),
    '4' => array(
        'color_primary' => "#523f6d",
        'color_secondary' => "#000",
        'color_carousel_control' => '#005f92',
        'color_comment_link' => '#271c37',
        'color_mdl_left_background' => '#dfcbfc',
        'color_comment_list_background' => '#c8b1e8',
        'color_comment_list_border' => '#836ba4',
        'color_picton_50_approx' => 'rgba(82, 63, 109, .5)',
        'color_dropdown_background' => '#444',
        'color_navtop_50_approx' => 'rgba(0, 0, 0, .5)',
        'color_picton_90_approx' => 'rgba(82, 63, 109, .9)',
        'color_picton_60_approx' => 'rgba(82, 63, 109, .6)',
        'color_picton_70_approx' => 'rgba(82, 63, 109, .75)',
        'color_picton_25_approx' => 'rgba(82, 63, 109, .25)',
        'color_tuatara_70_approx' => 'rgba(0, 0, 0, 0.7)'
    )
 );
